(**********************************************************************)
(*                                                                    *)
(* Function:    QOM -   QUEUED OUTPUT MATCH                           *)
(*                                                                    *)
(* Creation Date: 02/08/91                  From: NEW                 *)
(*                                                                    *)
(* Author:  Jeff Wright                                               *)
(*                                                                    *)
(* Description:                                                       *)
(* ------------                                                       *)
(* Allows user to schedule several matches at once with incremental   *)
(* offsets. This reduces CPU overhead. The table of matches can be    *)
(* executed once, n times or continuously. Using multiple table       *)
(* entries with the same edge type, allows the user to schedule an    *)
(* edge for > $7FFF counts from the reference time which can be the   *)
(* imediate tcr value, a value contained in any location in PRAM or   *)
(* the time of the last match of the previous sequence. A link mode   *)
(* allows the function to be fired from another channel.              *)
(*                                                                    *)
(* Updates:   By:   Modification:                                     *)
(* --------   ---   -------------                                     *)
(* 07/Oct/91   JW    Rearrange HSR & link to save instructions and    *)
(*                  improve link functionality.                       *)
(* 11/Oct/91   JW    Introduced flag0 to seperate link/nonlink modes  *)
(* 17/Oct/91   JW    Added new control bit to allow function to be    *)
(*                  started with a HSR and refernced to the last match*)
(*                  time of the previous match set (use ert as ref )  *)
(* 19/Nov/91   JW   Updated documentation to library standard         *)
(* 23/Jan/92   JW   RevB: Added read_mer to improve timing strategy   *)
(* 23/Jul/92   JW   RevC: Removed one read_mer so that 1st match is ref'd *)
(*                  to last EVENT time [same as LAST_MATCH_TIM] and   *)
(*                  subsequent matches are ref'd to last MATCH time.  *)
(*                  Allowed reduction in code size via reorganisation.*)
(*                  HSR ASSIGNMENT CHANGED.                           *)
(* 16/Jun/93   JW   Changed RevNo from C to 1.0 - for mask release    *)
(* 12/Aug/93   JL   Converted to new TPUMASM syntax.                  *)
(*                                                                    *)
(*--------------------------------------------------------------------*)
(* Standard Exits Used:-   End_Of_Phase: N         End_Of_Link: Y     *)
(*                                                                    *)
(* External Files included: NONE                                      *)
(*                                                                    *)
(* CODE SIZE excluding standard exits = 49 LONG WORDS                 *)
(*--------------------------------------------------------------------*)
(*                                                                    *)
(*                                                                    *)
(**********              This Revision:  1.1                  *********)
(*                                                                    *)
(**********   LAST MODIFIED: 12/Aug/93       BY: Jeff Loeliger ********)
(*                                                                    *)
(**********************************************************************)
(***************************************************************************)
(*Motorola reserves the right to make changes without further notice to any*)
(*product herein. Motorola makes no warranty, representation or guarantee  *)
(*regarding the suitability of its products for any particular purpose, nor*)
(*does Motorola assume any liability arising out of the application or use *)
(*of any product or circuit, and specifically disclaims any and all        *)
(*liability, including without limitation consequential or incidental      *)
(*damages. "Typical" parameters can and do vary in different applications. *)
(*All operating parameters, including "Typical",must be validated for each *)
(*customer application by customer's technical experts. Motorola does not  *)
(*convey any license under its patent rights nor the rights of others.     *)
(*Motorola products are not designed, intended, or authorized for use as   *)
(*components in systems intended for surgical implant into the body, or    *)
(*other applications intended to support or sustain life, or for any other *)
(*application in which the failure of the Motorola product could create a  *)
(*situation where injury or death may occur. Should Buyer purchase or use  *)
(*Motorola products for any such unintended or unauthorized application,   *)
(*Buyer, shall indemnify and hold Motorola and its officers, employees,    *)
(*subsidiaries, affiliates, and distributors harmless against all claims,  *)
(*costs, damages, and expenses, and reasonable attorney fees arising out   *)
(*of, directly or indirectly, any claim of personal injury or death        *)
(*associated with such unintended or unauthorized use, even if such claim  *)
(*alleges that Motorola was negligent regarding the design or manufacture  *)
(*of the part.                                                             *)
(*Motorola and the Motorola logo are registered trademarks of Motorola Inc.*) 
(*Motorola is an Equal Opportunity/Affirmative Action Employer.            *)
(*Copyright Motorola Inc. 1993                                             *)
(***************************************************************************)


(*()()()()()()()()()()() DATA STRUCTURE ()()()()()()()()()()()()()()()*)
(*                                                                    *)
(* name:               Written By:            Location  Bits:         *)
(* -----               -----------            ---------------         *)
(* REF_ADDR_QOM           CPU                 Parameter0  9..15       *)
(*                     7 msb of address in PRAM of reference time for *)
(*                     first match. Only used if BIT_B_QOM = 1        *)
(*                                                                    *)
(* BIT_B_QOM              CPU                 Parameter0  8           *)
(*                     Selects between immediate TCR reference of time*)
(*                     pointed to by REF_ADDR_QOM as 1st match ref tim*)
(*                                                                    *)
(* LAST_OFF_ADDR_QOM      CPU                 Parameter0  1..7        *)
(*                     7 msb of address of the last entry in match    *)
(*                     offset table                                   *)
(*                                                                    *)
(* BIT_A_QOM              CPU                 Parameter0  0           *)
(*                     0 = tcr1, 1 = tcr2 as match timebase           *)
(*                                                                    *)
(* LOOP_CNT_QOM          BOTH                 Parameter1  8..15       *)
(*                     Counts the number of times match table is      *)
(*                     repeated in loop 'n' times mode.               *)
(*                                                                    *)
(* OFF_PTR_QOM           BOTH                 Parameter1  1..7(8)     *)
(*                     During init: non zero value selects link mode. *)
(*                     After init: used as pointer into match table.  *)
(*                                                                    *)
(* BIT_C_QOM             BOTH                 Parameter1  0           *)
(*                     During init: 1 = use last match time as ref for*)
(*                     new match sequence.                            *)
(*                     After init: overwritten by OFF_PTR_QOM         *)
(*                                                                    *)
(* LAST_MATCH_TIM_QOM    TPU                  Parameter1  0..15       *)
(*                     At end of sequence in single shot or loop 'n'  *)
(*                     times mode, this value has the last match time *)
(*                     written - overwrites LOOP_CNT_QOM & OFF_PTR_QOM*)
(*                                                                    *)
(* OFFSET_n_QOM          CPU                  Parameters2,3,4 etc     *)
(*                     Entries in match table: bits 1..15 are shifted *)
(*                     match offset, and bit 0 determines ^ or v edge *)
(*                                                                    *)
(* HSQ1   HSQ0         Action                                         *)
(* ----   ----         ------                                         *)
(*  0       0          Single shot mode - match sequence executed once*)
(*  0       1          Loop n times and stop: n = LOOP_CNT_QOM (0=256)*)
(*  1       0          Execute match sequence continuously            *)
(*  1       1          As for %10                                     *)
(*                                                                    *)
(* Links Accepted: YES             Links Generated: NO                *)
(*                                                                    *)
(* Interrupts Generated After:     Init HSR complete.                 *)
(*                                 Link service complete  .           *)
(*                                 Match sequence complete. - no IRQ  *)
(*                                 in continuous mode.                *)
(*                                                                    *)
(*()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()*)


(*+++++++++++++++++++++  PARAMETER MACROS  +++++++++++++++++++++++++++*)

%macro LAST_OFF_ADDR_QOM     'prm0'.
%macro REF_ADDR_QOM          'prm0'.
%macro OFF_PTR_QOM           'prm1'.
%macro LOOP_CNT_QOM          'prm1'.
%macro LAST_MATCH_TIM_QOM    'prm1'.
%macro OFFSET_1_QOM          'prm2'.
(*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)


(*====================================================================*)
(*|||||||||||||||||||||  MICROCODE STARTS BELOW  |||||||||||||||||||||*)
(*VVVVVVVVVVVVVVVVVVVVV--------------------------VVVVVVVVVVVVVVVVVVVVV*)


(**********************************************************************)
(*                                                                    *)
(* ENTRY name:  HIGH_QOM                                              *)
(*                                                                    *)
(* STATE(S) ENTERED: S1 or S3                                         *)
(*                                                                    *)
(* PRELOAD PARAMETER : OFF_PTR_QOM                                    *)
(*                                                                    *)
(* ENTER WHEN : HSR = %01, pin=high. or HSR = %11. - REV C            *)
(*                                                                    *)
(* ACTION: Init.,set pin high and schedule first match if not in link *)
(*         mode. generate IRQ request                                 *)
(*                                                                    *)
(**********************************************************************)
%entry  ram p <- @OFF_PTR_QOM; start_address *; enable_match;
name = high_qom;
cond hsr1 = 1, hsr0 = 1.

%entry  ram p <- @OFF_PTR_QOM; start_address *; enable_match;
name = high_qom1;
cond hsr1 = 0, hsr0 = 1,pin = 1.

high_qom:
         chan pin := high, pac := no_change, tbs := out_m1_c1.

init_qom:
         au p_low :=>> p_low, ccl;   (* check bits 0 & 1 of OFF_PTR for ref *)
         ram p <- @LAST_OFF_ADDR_QOM.          (* - and link mode selection *)

         If C = 1 then goto tst_zbit_qom, flush; (* last ert as new ref time? *)
         chan set flag1.              (* if so set flg & do not force match *)

         au ert := tcr1;                       (*  Force immediate match to *)
         chan write_mer, neg_mrl, neg_tdl;        (* clear any pending ones *)
         chan clear flag1.

tst_zbit_qom:
         If Z=1 then goto link_qom, flush;
         chan clear flag0.

         chan neg_mrl, neg_tdl, neg_lsl;           (* clear immediate match *)
         chan set flag0;                      (* remember this is link mode *)
         chan cir; end.                      (* possible end of states 1,2,3*)


(**********************************************************************)
(*                                                                    *)
(* ENTRY name:  LINK_QOM                                              *)
(*                                                                    *)
(* STATE(S) ENTERED: S4                                               *)
(*                                                                    *)
(* PRELOAD PARAMETER : LAST_OFF_ADDR_QOM                              *)
(*                                                                    *)
(* ENTER WHEN: lsr = 1, flag0 = 1                                     *)
(*                                                                    *)
(* ACTION :  Initialise and start match sequence. Generate IRQ.       *)
(*                                                                    *)
(**********************************************************************)
%entry  ram p <- @LAST_OFF_ADDR_QOM; start_address *; disable_match;
name = link_qom;
cond hsr1 = 0,hsr0 = 0,lsr = 1, flag0 = 1.

Link_qom:
         au nil :=>> p, ccl;           (* check which TCR has been selected *)
         ram p <- @OFF_PTR_QOM.            (* get loop_cnt & offset pointer *)

         if C= 0 then goto first_m_qom;
         chan tbs := out_m1_c1.

         au a := tcr1;
         ram diob <- @OFFSET_1_QOM.               (* get first match offset *)

         au a := tcr2.

         chan tbs := out_m2_c2.

first_m_qom:
         au p_low := chan_reg + #$04.          (* initialise offset pointer *)

         au sr :=>> diob, ccl;   (* correct offset value and edge type -> C *)
         ram p -> @OFF_PTR_QOM.          (* save initialised offset pointer *)

         au ert := ert + sr;
         ram p <- @REF_ADDR_QOM.                 (* read_mer removed - revC *)

         If C = 1 then goto tst_b_qom;                     (* set edge type *)
         chan pac := high, enable_mtsr.

         au diob :=>> p_high,ccl. (* get REF_ADDR in diob & check if needed *)

         chan pac := low.

tst_b_qom:
         If flag1 = 1 then goto set_m1_qom,flush.

         au diob :=<< diob.                         (* correct REF_ADDR_QOM *)

         If C=0 then goto set_m1_qom.              (* immediate reference ? *)

         au ert := sr + a;                   (* match time = TCR + OFFSET_1 *)
         ram p <- by_diob.                                  (* get ref time *)

         au ert := sr + p.              (* match time = REF_TIME + OFFSET_1 *)

set_m1_qom:
         chan write_mer, neg_mrl, neg_tdl, neg_lsl;            (* set match *)
         chan cir; end.        (* Possible end of states 1,2,3. End state 4 *)



(**********************************************************************)
(*                                                                    *)
(* ENTRY name:   LOW_QOM                                              *)
(*                                                                    *)
(* STATE(S) ENTERED: S2 or S3                                         *)
(*                                                                    *)
(* PRELOAD PARAMETER : OFF_PTR_QOM                                    *)
(*                                                                    *)
(* ENTER WHEN : HSR = %10. or HSR = %01, pin = low. - REV C           *)
(*                                                                    *)
(* ACTION: Init.,set pin low  and schedule first match if not in link *)
(*         mode. generate IRQ request                                 *)
(*                                                                    *)
(**********************************************************************)
%entry  ram p <- @OFF_PTR_QOM; start_address *; enable_match;
name = low_qom;
cond hsr1 = 1, hsr0 = 0.

%entry  ram p <- @OFF_PTR_QOM; start_address *; enable_match;
name = low_qom1;
cond hsr1 = 0, hsr0 = 1,pin = 0.

low_qom:
         If TRUE then goto init_qom, flush;
         chan pin := low, pac := no_change, tbs := out_m1_c1.




(**********************************************************************)
(*                                                                    *)
(* ENTRY name:  QOM_MATCH                                             *)
(*                                                                    *)
(* STATE(S) ENTERED: S5                                               *)
(*                                                                    *)
(* PRELOAD PARAMETER : LAST_OFF_ADDR_QOM                              *)
(*                                                                    *)
(* ENTER WHEN : m/tsr = 1, lsr = 0                                    *)
(*                                                                    *)
(* ACTION :  Update match table pointer and check for table end:      *)
(*           - if not table end then schedule next match              *)
(*           - if table end & continuous mode then reset pointer and  *)
(*             schedule first match.                                  *)
(*           - if table end and loop mode then update loop counter:   *)
(*                - if loop count not=0 then reset table pointer and  *)
(*                  schedule first match.                             *)
(*                - if loop cnt =0 then store match time, request IRQ *)
(*                  and end.                                          *)
(*                                                                    *)
(**********************************************************************)
%entry  ram p <- @LAST_OFF_ADDR_QOM; start_address *; disable_match;
name = qom_match;
cond hsr1 = 0,hsr0 = 0,lsr = 0,m/tsr = 1.

qom_m:
         au sr :=>> p_low;      (* get rid of tcr select bit for test below *)
         ram p <- @OFF_PTR_QOM.

         au a :=>> p_low.        (* Subtarct current pointer from last Addr *)

         au  nil := sr - a, ccl;
         ram diob <- @OFFSET_1_QOM.       (* get 1st offset in case we loop *)

         If LOW_SAME = 1 then goto test_lp_qom, flush.
                                              (* If >= then test loop modes *)

         au diob := p_low + #2.                   (* Advance offset pointer *)

         au p_low := diob;
         ram diob <- by_diob.                      (* get next match offset *)

set_m_qom:
         read_mer;
         au a :=>> diob, ccl;        (* correct it and get edge type into C *)
         ram p -> @OFF_PTR_QOM.            (* save new pointer & loop count *)

         If C = 0 then goto write_m_qom,flush.

         au ert := ert + a;
         chan write_mer, PAC := high, neg_mrl, neg_tdl;
         end.                                             (* end of state 5 *)

write_m_qom:
         au ert := ert + a;
         chan write_mer, PAC := low, neg_mrl, neg_tdl;
         end.                                             (* end of state 5 *)

test_lp_qom:
         If hsq1 = 1 then goto set_m_qom.               (* Continous mode ? *)

         au p_low := chan_reg + #$04.

         If hsq0 = 0 then goto end_qom.          (* - No so is it Loop mode *)

         au p_high := p_high - 1, ccl.             (* - Yes so dec loop_cnt *)

         If Z =0 then goto set_m_qom, flush.          (* finished looping ? *)

end_qom:
         au p := ert;                      (* save event time of last match *)
         ram p -> @LAST_MATCH_TIM_QOM.

         chan neg_tdl, neg_mrl;
         chan cir;                                  (* end & interrupt CPU, *)
         chan clear flag0;                     (* disable any further links *)
         end.                                             (* end of state 5 *)


(**********************************************************************)
(*    UNUSED ENTRIES - execute appropriate termination                *)
(**********************************************************************)

%entry  start_address  End_of_link;
name = del_lnk_qom;
cond hsr1 = 0,hsr0 = 0,lsr = 1, flag0 = 0.
